% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure.R
\name{measure_cat}
\alias{measure_cat}
\title{Measure Performance for Multi-Class Classification Models}
\usage{
measure_cat(obs, pred)
}
\arguments{
\item{obs}{A factor vector of observed class labels. Each level represents a unique class.}

\item{pred}{A numeric matrix of predicted probabilities, where each row corresponds to an observation,
and each column corresponds to a class. The number of columns must match the number of levels in \code{obs}.}
}
\value{
A list containing:
\describe{
\item{\code{log_loss}}{The negative log-likelihood averaged across observations.}
\item{\code{ROC}}{ROC generated using \code{pROC::roc}}
\item{\code{AUC}}{The multiclass Area Under the Curve (AUC) as computed by \code{pROC::multiclass.roc}.}
}
}
\description{
Evaluates the performance of a multi-class classification model using log loss and multiclass AUC.
}
\details{
The log loss is calculated as:
\deqn{-\frac{1}{N} \sum_{i=1}^N \sum_{c=1}^C y_{ic} \log(p_{ic})}
where \eqn{y_{ic}} is 1 if observation \eqn{i} belongs to class \eqn{c}, and \eqn{p_{ic}} is the
predicted probability for that class.

The AUC is computed using the \code{pROC::multiclass.roc} function, which provides an overall measure
of model performance for multiclass classification.
}
\examples{
library(pROC)
obs <- factor(c("A", "B", "C"), levels = LETTERS[1:3])
pred <- matrix(
  c(
    0.8, 0.1, 0.1,
    0.2, 0.6, 0.2,
    0.7, 0.2, 0.1
  ),
  nrow = 3, byrow = TRUE
)
measure_cat(obs, pred)
# Returns: list(log_loss = 1.012185, ROC = <ROC>, AUC = 0.75)

}
