% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.type.one.var.R
\name{check.type.one.var}
\alias{check.type.one.var}
\title{Verify the type of one variable}
\usage{
check.type.one.var(data.to.work, show.message = 0, variable.name)
}
\arguments{
\item{data.to.work}{is a data set containing the variables to be verified.}

\item{show.message}{is a parameter indicating if the function will or not show a message.}

\item{variable.name}{is the name of variable to be checked.}
}
\value{
A variable with the code indicating the type of variable and a message (or not).
}
\description{
Receives a specific variable and return a number indicating its type. The variables can be 1 is integer, 2 is numeric, 3 is factor, 8 is character.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Set enviroment
# setwd("to your working directory")
# Load packages
library(bnpa)
# Use working data sets from package
data(dataQuantC)
head(dataQuantC)
# Adding random data to dataQuantC, function will return TRUE
dataQuantC$Z <- round(runif(500, min=0, max=1000),2)
# Converting the numeric variable into factor
dataQuantC$Z <- factor(dataQuantC$Z)
# Check and return a numeric value correspondig to the variable type
# Set the variable name
variable.name = "A"
# identify the type
check.type.one.var(dataQuantC, show.message=0, variable.name)
# Set the variable name
variable.name = "Z"
# identify the type
check.type.one.var(dataQuantC, show.message=0, variable.name)
}
\references{
GUJARATI, Damodar N. Basic econometrics. Tata McGraw-Hill Education, 2009.
}
\author{
Elias Carvalho
}
