% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{s1}
\alias{s1}
\title{qPCR data set by Boggy et al. (2010)}
\format{
A \link[tibble:tibble-package]{tibble} with 480 rows and 10 variables:
\describe{
\item{\code{plate}}{Plate identifier. For this data set it is always missing
(\code{NA}).}
\item{\code{well}}{Well identifier.}
\item{\code{dye}}{The type of dye used. In this data set the values are always
\code{"SYTO 13"}, meaning 2 mM of the dsDNA dye SYTO-13 (Invitrogen, Carlsbad, CA).}
\item{\code{target}}{Target identifier: the amplicon used, a random sequence
dubbed \code{"S1"} by the original authors.}
\item{\code{sample_type}}{Sample type (all curves are standards, i.e. \code{"std"}).}
\item{\code{replicate}}{Replicate identifier: either 1 or 2.}
\item{\code{copies}}{Standard copy number.}
\item{\code{dilution}}{Dilution factor. Higher number means greater dilution.}
\item{\code{cycle}}{PCR cycle.}
\item{\code{fluor}}{Raw fluorescence values.}
}
}
\source{
\doi{10.1371/journal.pone.0012355}
}
\description{
The qPCR data set named \emph{s1} comprises a six-point, ten-fold dilution series,
replicated in duplicates targeting an amplicon designed with a random
sequence that minimizes secondary structure and off-target primer binding.
Please read the \emph{Quantitative PCR data} section, \emph{qPCR assays} subsection of
Boggy et al. (2010) for more details.
}
\examples{
s1

}
\keyword{datasets}
