% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastNadaraya.R
\name{fastNadaraya}
\alias{fastNadaraya}
\title{Nadaraya-Watson Estimator for Transition Densities for Markov chains.}
\usage{
fastNadaraya(x, bandwidth)
}
\arguments{
\item{x}{A numeric vector representing a Markov process.}

\item{bandwidth}{A real number; the kernel bandwidth smoothing parameter}
}
\value{
Returns a numeric vector of size \code{length(x) - 1}, containing
the estimated transition densities for each state transition in the Markov chain.
}
\description{
Calculates the Nadaraya-Watson estimator for estimating the transition densities
of a Markov chain. This function is particularly useful for approximating
transition kernels in Markov chain analysis.
}
\details{
The \code{fastNadaraya} function computes the estimated transition densities
\eqn{p_n(X_i, X_{i+1})} of a Markov chain. It is based on the Nadaraya kernel-type
estimator for the transition density, with a bandwidth \code{bandwidth} provided by the user.
This function is used in conjunction with \code{\link{findBestEpsilon}}
to determine optimal small set for the Regenerative Block Bootstrap \code{\link{regenboot}}.
}
\examples{
x = arima.sim(1000, model=list(ar=c(0.4)))
h = bandw1(x)
fastNadaraya(x,h)

}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P., Clémençon, S. (2006a). Regenerative Block
Bootstrap for Markov Chains. \emph{Bernoulli},  \bold{12}, 689-712.

Bertail, P. and Clémençon, S. (2006).
\emph{Regeneration-based statistics for Harris recurrent
Markov chains}, pages 1-54.
Number 187 in Lecture notes in Statistics. Springer.

Radulović, D. (2006). Renewal type bootstrap for Markov chains. \emph{Test},
\bold{13}, 147-192.
}
\seealso{
\code{\link{findBestEpsilon}},
\code{\link{regenboot}},
\code{\link{bandw1}}.
}
\keyword{"Kernel}
\keyword{"Markov}
\keyword{"Regenerative}
\keyword{"Transition}
\keyword{Block}
\keyword{Bootstrap"}
\keyword{chains"}
\keyword{density}
\keyword{estimation"}
\keyword{methods"}
