% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverseGamma.R
\name{InverseGamma}
\alias{InverseGamma}
\title{Inverse Gamma distribution}
\description{
A R6 class to represent an inverse Gamma distribution.
}
\details{
See \href{https://en.wikipedia.org/wiki/Inverse-gamma_distribution}{Wikipedia}.
}
\examples{
if(require("plotly")) {
x_ <- seq(0, 2, length.out = 100L)
alpha_ <- seq(0.5, 2.5, length.out = 100L)
dsty <- vapply(alpha_, function(alpha) {
  InverseGamma$new(alpha, beta = 1)$d(x_)
}, numeric(length(x_)))
#
txt <- matrix(NA_character_, nrow = length(x_), ncol = length(alpha_))
for(i in 1L:nrow(txt)) {
  for(j in 1L:ncol(txt)) {
    txt[i, j] <- paste0(
      "x: ", formatC(x_[i]),
      "<br> alpha: ", formatC(alpha_[j]),
      "<br> density: ", formatC(dsty[i, j])
    )
  }
}
#
plot_ly(
  x = ~alpha_, y = ~x_, z = ~dsty, type = "surface",
  text = txt, hoverinfo = "text", showscale = FALSE
) \%>\% layout(
  title = "Inverse Gamma distribution",
  margin = list(t = 40, r= 5, b = 5, l = 5),
  scene = list(
    xaxis = list(
      title = "alpha"
    ),
    yaxis = list(
      title = "x"
    ),
    zaxis = list(
      title = "density"
    )
  )
)
}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{alpha}}{Get or set the value of \code{alpha}.}

\item{\code{beta}}{Get or set the value of \code{beta}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-InverseGamma-new}{\code{InverseGamma$new()}}
\item \href{#method-InverseGamma-d}{\code{InverseGamma$d()}}
\item \href{#method-InverseGamma-p}{\code{InverseGamma$p()}}
\item \href{#method-InverseGamma-q}{\code{InverseGamma$q()}}
\item \href{#method-InverseGamma-r}{\code{InverseGamma$r()}}
\item \href{#method-InverseGamma-mean}{\code{InverseGamma$mean()}}
\item \href{#method-InverseGamma-median}{\code{InverseGamma$median()}}
\item \href{#method-InverseGamma-mode}{\code{InverseGamma$mode()}}
\item \href{#method-InverseGamma-sd}{\code{InverseGamma$sd()}}
\item \href{#method-InverseGamma-variance}{\code{InverseGamma$variance()}}
\item \href{#method-InverseGamma-skewness}{\code{InverseGamma$skewness()}}
\item \href{#method-InverseGamma-kurtosis}{\code{InverseGamma$kurtosis()}}
\item \href{#method-InverseGamma-kurtosisExcess}{\code{InverseGamma$kurtosisExcess()}}
\item \href{#method-InverseGamma-clone}{\code{InverseGamma$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-new"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-new}{}}}
\subsection{Method \code{new()}}{
New inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$new(alpha, beta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{shape parameter, \code{>0}}

\item{\code{beta}}{scale parameter, \code{>0}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{inverseGamma} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-d"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-d}{}}}
\subsection{Method \code{d()}}{
Density function of the inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$d(x, log = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector of positive numbers}

\item{\code{log}}{Boolean, whether to return the logarithm of the density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The density or the log-density evaluated at \code{x}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-p"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-p}{}}}
\subsection{Method \code{p()}}{
Cumulative distribution function of the inverse Gamma
  distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$p(q, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{numeric vector of quantiles}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The cumulative probabilities corresponding to \code{q}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-q"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-q}{}}}
\subsection{Method \code{q()}}{
Quantile function of the inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$q(p, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{numeric vector of probabilities}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The quantiles corresponding to \code{p}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-r"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-r}{}}}
\subsection{Method \code{r()}}{
Sampling from the inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$r(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of simulations}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector of length \code{n}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-mean"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-mean}{}}}
\subsection{Method \code{mean()}}{
Mean of the inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mean of the inverse Gamma distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-median"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-median}{}}}
\subsection{Method \code{median()}}{
Median of the inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$median()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The median of the inverse Gamma distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-mode"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-mode}{}}}
\subsection{Method \code{mode()}}{
Mode of the inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mode of the inverse Gamma distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-sd"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-sd}{}}}
\subsection{Method \code{sd()}}{
Standard deviation of the inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$sd()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The standard deviation of the inverse Gamma distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-variance"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-variance}{}}}
\subsection{Method \code{variance()}}{
Variance of the inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$variance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The variance of the inverse Gamma distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-skewness"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-skewness}{}}}
\subsection{Method \code{skewness()}}{
Skewness of the inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$skewness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The skewness of the inverse Gamma distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-kurtosis"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-kurtosis}{}}}
\subsection{Method \code{kurtosis()}}{
Kurtosis of the inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$kurtosis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis of the inverse Gamma distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-kurtosisExcess"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-kurtosisExcess}{}}}
\subsection{Method \code{kurtosisExcess()}}{
Kurtosis excess of the inverse Gamma distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$kurtosisExcess()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis excess of the inverse Gamma distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InverseGamma-clone"></a>}}
\if{latex}{\out{\hypertarget{method-InverseGamma-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InverseGamma$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
