% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_tests.R
\name{z_tests}
\alias{z_tests}
\alias{one_sample_z_test_params}
\alias{one_sample_z_test}
\alias{two_sample_z_test}
\title{Z-Tests}
\usage{
one_sample_z_test_params(
  sample_mean,
  sample_variance,
  num_samples,
  assumed_mean
)

one_sample_z_test(u, assumed_mean)

two_sample_z_test(u, v)
}
\arguments{
\item{sample_mean}{A single value.}

\item{sample_variance}{A single value.}

\item{num_samples}{A single value.}

\item{assumed_mean}{A single value.}

\item{u}{A numeric vector.}

\item{v}{A numeric vector.}
}
\value{
A two-element numeric vector containing the t-statistic and the p-value.
}
\description{
Functions for Z - Tests.
}
\examples{
# One Sample T-Test Parameters
one_sample_z_test_params(sample_mean = 2, sample_variance = 1, num_samples = 30, assumed_mean = 0)
# One Sample T-Test
one_sample_z_test(c(5, 6, 7), assumed_mean = 4)
# Two Sample T-Test
two_sample_z_test(c(5, 6, 7), c(4, 5, 6))
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/z_test.html}{Boost Documentation} for more details on the mathematical background.
}
