% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/braids.R
\name{bronfmanPolynomials}
\alias{bronfmanPolynomials}
\title{Bronfman polynomials}
\usage{
bronfmanPolynomials(N)
}
\arguments{
\item{N}{maximum number of strands}
}
\value{
A list of integer vectors representing the Bronfman polynomials;
  each vector represents the polynomial coefficients in increasing order.
}
\description{
The Bronfman polynomial of a braid group is the reciprocal of
  the growth function of the positive braids. This function computes the
  Bronfman polynomial of the braid group on \code{n} strands for \code{n}
  going to \code{1} to \code{N}.
}
\examples{
bronfmanPolynomials(3) # 1, 1 - X, 1 - 2X + X^3
}
