% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{brainGraphList}
\alias{brainGraphList}
\alias{make_brainGraphList}
\alias{make_brainGraphList.array}
\alias{make_brainGraphList.corr_mats}
\alias{Extract.brainGraphList}
\alias{[.brainGraphList}
\alias{print.brainGraphList}
\alias{is.brainGraphList}
\alias{nobs.brainGraphList}
\alias{as_brainGraphList}
\title{Create a list of brainGraph graphs}
\usage{
make_brainGraphList(
  x,
  atlas,
  type = c("observed", "random"),
  level = c("subject", "group", "contrast"),
  set.attrs = TRUE,
  modality = NULL,
  weighting = NULL,
  threshold = NULL,
  gnames = NULL,
  ...
)

\method{make_brainGraphList}{array}(
  x,
  atlas,
  type = c("observed", "random"),
  level = c("subject", "group", "contrast"),
  set.attrs = TRUE,
  modality = NULL,
  weighting = NULL,
  threshold = NULL,
  gnames = NULL,
  grpNames = NULL,
  subnet = NULL,
  mode = "undirected",
  weighted = NULL,
  diag = FALSE,
  .progress = getOption("bg.progress"),
  ...
)

\method{make_brainGraphList}{corr_mats}(
  x,
  atlas = x$atlas,
  type = "observed",
  level = "group",
  set.attrs = TRUE,
  modality = NULL,
  weighting = NULL,
  threshold = x$densities,
  gnames = names(x$r.thresh),
  grpNames = gnames,
  mode = "undirected",
  weighted = NULL,
  diag = FALSE,
  .progress = getOption("bg.progress"),
  ...
)

\method{[}{brainGraphList}(x, i, g = NULL, drop = TRUE)

\method{print}{brainGraphList}(x, ...)

is.brainGraphList(x)

\method{nobs}{brainGraphList}(object, ...)

as_brainGraphList(
  g.list,
  type = c("observed", "random"),
  level = c("subject", "group", "contrast")
)
}
\arguments{
\item{x}{3-D numeric array of all subjects' connectivity matrices (for a
single threshold) or a \code{corr_mats} object}

\item{atlas}{Character string specifying the brain atlas}

\item{type}{Character string indicating the type of graphs. Default:
\code{observed}}

\item{level}{Character string indicating whether the graphs are subject-,
group-, or contrast-specific. Default: \code{'subject'}}

\item{set.attrs}{Logical indicating whether to assign all graph-, vertex-,
and edge-level attributes (via \code{\link{set_brainGraph_attr}}). Default:
\code{TRUE}}

\item{modality}{Character string indicating imaging modality (e.g. 'dti').
Default: \code{NULL}}

\item{weighting}{Character string indicating how the edges are weighted
(e.g., 'fa', 'pearson', etc.). Default: \code{NULL}}

\item{threshold}{Integer or number indicating the threshold used when
\dQuote{sparsifying} the connectivity matrix (if any). Default: \code{NULL}}

\item{gnames}{Character vector of graph names (e.g., study IDs if
\code{level='subject'}). Default: \code{NULL}}

\item{...}{Other arguments passed to \code{\link{set_brainGraph_attr}}}

\item{grpNames}{Character (or factor) vector of group names. If \code{level ==
'group'}, then you do not need to include this argument (the group names
will be the same as \code{gnames}). Default: \code{NULL})}

\item{subnet}{Integer or character vector indicating the vertices to keep, if
you are interested in working with a subset of an atlas. By default, all
vertices are used.}

\item{mode}{Character string defining how the matrix should be interpreted.
Default: \code{'undirected'}}

\item{weighted}{Logical specifying whether to create a weighted network}

\item{diag}{Logical indicating whether to include the diagonal of the
connectivity matrix. Default: \code{FALSE}}

\item{.progress}{Logical indicating whether to print a progress bar. Default:
\code{getOption('bg.progress')}}

\item{i}{Integer, character, or logical vector for subsetting by subject, or
by group (if \code{x$level='group'})}

\item{g}{Integer, character, or logical vector for subsetting by group (if
\code{x$level='subject'})}

\item{drop}{If \code{TRUE} (the default), then return only the list of
graphs; otherwise, subset the graphs and return the entire object}

\item{object}{A \code{brainGraphList} object}

\item{g.list}{List of graph objects}
}
\value{
\code{make_brainGraphList} returns an object of class
  \code{brainGraphList} with elements:
  \item{threshold}{The specified threshold/density}
  \item{version}{The versions of \code{R}, \code{igraph}, and
    \code{brainGraph} used when creating the graphs}
  \item{atlas}{The atlas common to all the graphs}
  \item{modality}{The imaging modality (if supplied)}
  \item{weighting}{A string indicating what edge weights represent (if
    applicable)}
  \item{graphs}{A \emph{named list} of \code{brainGraph} graphs; the names
    correspond to the individual graphs' Study IDs}

\code{[} -- A \code{brainGraphList} object (if \code{drop=FALSE}) or
  a list of graphs
}
\description{
\code{make_brainGraphList} creates a \code{brainGraphList} object, a list
containing a set of graphs for all subjects (or group-average graphs) in a
study at a specific threshold (or density), in addition to some graph-level
attributes common to those graphs.

The \code{[} method will let you subset/slice the graphs for individual
subjects and/or \emph{groups}.

\code{as_brainGraphList} coerces a list of graphs to a \code{brainGraphList}
object. It is assumed that certain metadata attributes -- threshold, package
version, atlas, imaging modality, edge weighting, and whether they are
random graphs -- are identical for all graphs in the list.
}
\details{
In addition to creating the initial \code{igraph} graphs from the
connectivity matrices, then attributes will be calculated and assigned for
each graph via \code{\link{set_brainGraph_attr}} if \code{set.attrs=TRUE}.
Other arguments can be passed to that function. You may display a progress
bar by setting \code{.progress=TRUE}.

This object can be considered comparable to a 4-D \emph{NIfTI} file,
particularly that returned by FSL's \emph{TBSS} \dQuote{prestats} step since
that file contains the FA volumes for all study subjects.

To convert an object with 3 \dQuote{levels} (i.e., subject-level lists from
an older \code{brainGraph} version), see the code in the Examples below.
}
\note{
If the input is a \code{corr_mats} object, and the extent of the 3-D
array is greater than 1, then only the first will be converted to a graph.
}
\section{Subsetting/extracting}{

The first index is for subsetting the individual graphs. The second index is
for subsetting by group membership and requires that the graphs have a
\code{Group} graph attribute. When both are included, the first index cannot
have length or numeric value greater than the number of \emph{remaining}
subjects \emph{after} subsetting by group.

If the indexing vector(s) is (are) \code{character}, the vector(s) must
contain one (or more) of the subject or group names. If \code{logical}, its
length must equal the number of subjects or groups.
}

\examples{
\dontrun{
# Create a list, one for each threshold
g <- vector('list', length(thresholds))
for (i in seq_along(thresholds)) {
  g[[i]] <- make_brainGraphList(A.norm.sub[[i]], thresholds[i], atlas,
      covars.dti$Study.ID, covars.dti$Group, modality='dti', weighting='fa')
}
}
\dontrun{
# Subset the first 10 subjects, irrespective of group
my.bgl[1:10]

# Return object for only 'Control' subjects
my.bgl[, 'Control']

# Return object with graphs from groups 1 and 3
my.bgl[g=c(1, 3), drop=FALSE]

# Subset the first 10 subjects of group 2
my.bgl[1:10, 2]
}
\dontrun{
## Convert old version single-subject graph lists
## g[[1]] is group 1, g[[1]][[1]] is threshold 1, g[[1]][[1]][[1]] is subj. 1
kNumThresholds <- length(g[[1]])
g.l <- vector('list', kNumThresholds)
for (i in seq_len(kNumThresholds)) {
  g.l[[i]] <- as_brainGraphList(do.call(Map, c(c, g))[[i]])
}
}
}
\seealso{
Other Graph creation functions: 
\code{\link{Creating_Graphs}},
\code{\link{Creating_Graphs_GLM}},
\code{\link{make_ego_brainGraph}()}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Graph creation functions}
