% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_graphs.R
\name{Creating_Graphs}
\alias{Creating_Graphs}
\alias{make_brainGraph}
\alias{make_brainGraph.igraph}
\alias{make_brainGraph.matrix}
\alias{make_brainGraph.bg_mediate}
\alias{is.brainGraph}
\alias{summary.brainGraph}
\alias{make_empty_brainGraph}
\title{Create a brainGraph object}
\usage{
make_brainGraph(
  x,
  atlas,
  type = c("observed", "random"),
  level = c("subject", "group", "contrast"),
  set.attrs = TRUE,
  modality = NULL,
  weighting = NULL,
  threshold = NULL,
  ...
)

\method{make_brainGraph}{igraph}(
  x,
  atlas,
  type = c("observed", "random"),
  level = c("subject", "group", "contrast"),
  set.attrs = TRUE,
  modality = NULL,
  weighting = NULL,
  threshold = NULL,
  name = NULL,
  Group = NULL,
  subnet = NULL,
  ...
)

\method{make_brainGraph}{matrix}(
  x,
  atlas,
  type = c("observed", "random"),
  level = c("subject", "group", "contrast"),
  set.attrs = TRUE,
  modality = NULL,
  weighting = NULL,
  threshold = NULL,
  name = NULL,
  Group = NULL,
  subnet = NULL,
  mode = "undirected",
  weighted = NULL,
  diag = FALSE,
  ...
)

\method{make_brainGraph}{bg_mediate}(
  x,
  atlas = x$atlas,
  type = "observed",
  level = "contrast",
  set.attrs = FALSE,
  modality = NULL,
  weighting = NULL,
  threshold = NULL,
  ...
)

is.brainGraph(x)

\method{summary}{brainGraph}(object, print.attrs = c("all", "graph", "vertex", "edge", "none"), ...)

make_empty_brainGraph(
  atlas,
  type = c("observed", "random"),
  level = c("subject", "group", "contrast"),
  modality = NULL,
  weighting = NULL,
  threshold = NULL,
  name = NULL,
  Group = NULL,
  ...
)
}
\arguments{
\item{x}{An \code{igraph} graph object, numeric matrix, or \code{bg_mediate}
object}

\item{atlas}{Character string specifying the brain atlas}

\item{type}{Character string indicating the type of graphs. Default:
\code{observed}}

\item{level}{Character string indicating whether the graphs are subject-,
group-, or contrast-specific. Default: \code{'subject'}}

\item{set.attrs}{Logical indicating whether to assign all graph-, vertex-,
and edge-level attributes (via \code{\link{set_brainGraph_attr}}). Default:
\code{TRUE}}

\item{modality}{Character string indicating imaging modality (e.g. 'dti').
Default: \code{NULL}}

\item{weighting}{Character string indicating how the edges are weighted
(e.g., 'fa', 'pearson', etc.). Default: \code{NULL}}

\item{threshold}{Integer or number indicating the threshold used when
\dQuote{sparsifying} the connectivity matrix (if any). Default: \code{NULL}}

\item{...}{Arguments passed to \code{\link{set_brainGraph_attr}}}

\item{name}{Character string indicating subject ID or group/contrast name,
depending on the \code{level}. Default: \code{NULL}}

\item{Group}{Character string indicating group membership. Default:
\code{NULL}}

\item{subnet}{Integer or character vector indicating the vertices to keep, if
you are interested in working with a subset of an atlas. By default, all
vertices are used.}

\item{mode}{Character string defining how the matrix should be interpreted.
Default: \code{'undirected'}}

\item{weighted}{Logical specifying whether to create a weighted network}

\item{diag}{Logical indicating whether to include the diagonal of the
connectivity matrix. Default: \code{FALSE}}

\item{object}{A \code{brainGraph} object}

\item{print.attrs}{Character string indicating whether or not to list the
object's attributes (default: \code{all})}
}
\value{
A \code{brainGraph} graph object with additional graph-, vertex-, and
  edge-level attributes (see below).

The method for \code{bg_mediate} returns a \code{brainGraph_mediate}
  object, which has extra attributes:
  \item{Graph}{\emph{mediator}, \emph{treat}, \emph{outcome}, \emph{nobs}}
  \item{Vertex}{\emph{b?.acme, p?.acme}, \emph{b?.ade, p?.ade},
    \emph{b?.prop, p?.prop}, \emph{b.tot, p.tot}}

\code{make_empty_brainGraph} -- An empty \code{brainGraph} graph
  object
}
\description{
\code{make_brainGraph} is the main creation function for creating a
\code{brainGraph} graph object. This is simply an \code{igraph} graph
object with additional attributes (at all levels). Several of the graph-level
attributes serve the purpose of providing metadata on how the connectivity
matrices/networks were created.

\code{make_brainGraph.bg_mediate} creates a graph only for
\emph{vertex}-level analyses.

\code{make_empty_brainGraph} creates an empty undirected \code{brainGraph}
object with vertex count equal to the atlas specified; i.e., it creates a
graph with 0 edges. Typically used to present results from an analysis in
which edges don't make sense (e.g., GLM comparing differences in a
vertex-level attribute).
}
\section{Graph-level attributes}{

Graph-level attributes added are:
\describe{
  \item{version}{The R, \code{brainGraph}, and \code{igraph} package versions
    used to create the graph}
  \item{date}{The creation date, from \code{\link{as.POSIXct}}}
  \item{atlas}{Character string denoting the brain atlas used}
  \item{type}{Character string specifying whether this is an \emph{observed}
    or \emph{random} graph}
  \item{modality}{The imaging modality; you can choose anything you like,
    but the \code{summary.brainGraph} knows about \code{dti}, \code{fmri},
    \code{thickness}, \code{area}, and \code{volume}}
  \item{weighting}{What edge weights represent; you can choose anything you
    like, but \code{summary.brainGraph} knows about \code{fa}, \code{sld}
    (streamline density, tractography), \code{pearson}, \code{spearman},
    \code{kendall}, and \code{partial} (partial correlation coefficient)}
  \item{threshold}{Numeric indicating the threshold used to create the final
    connectivity matrix (if any)}
  \item{name}{Character string specifying the study ID or group/contrast
    name, depending on the \code{level} argument}
  \item{Group}{Character string specifying the experimental group that the
    given subject belongs to, or if it is a group-level graph}
  \item{subnet}{Integer vector, if \code{subnet} was specified in the call}
}
}

\section{Vertex attributes}{

Vertex-level attributes added are:
\describe{
  \item{name}{The names of the brain regions in the network}
  \item{lobe}{The names of the major brain lobes for each vertex}
  \item{hemi}{The names of the hemisphere for each vertex (either \code{'L'},
    \code{'R'}, or \code{'B'})}
  \item{lobe.hemi}{The lobe-hemisphere combination (represented as an
    \emph{integer} vector)}
  \item{class}{The tissue class (if applicable)}
  \item{network}{The network (if the atlas is \code{dosenbach160})}
  \item{x,y,z}{The spatial coordinates of the (centers-of-mass) brain regions
    in MNI space}
  \item{x.mni,y.mni,z.mni}{Same as above}
  \item{color.lobe,color.class,color.network}{Colors for vertices of their
    respective membership}
  \item{circle.layout}{Integer vector indicating the order (going
    counter-clockwise from the top) for circular layouts}
}
}

\section{Edge attributes}{

Edge-level attributes added are:
\describe{
  \item{color.lobe,color.class,color.network}{Correspond to the vertex
    attribute of the same name. Inter-group edges will be colored
    \emph{gray}}
}
}

\section{Specifying a subnetwork}{

You can create a graph for a subset of an atlas's regions with the
\code{subnet} argument. This can either be a numeric or character vector. If
the input object (either a matrix or an \code{igraph} graph) has fewer
rows/columns or vertices, respectively, than the atlas then the \code{subnet}
graph attribute will also be added to the return object. This may occur if,
for example, you use \code{\link{make_auc_brainGraph}} on graphs that were
initially created from subnetworks.
}

\examples{
\dontrun{
bg <- make_brainGraph(A, 'dkt', modality='dti', weighting='fa',
  mode='undirected', diag=FALSE, weighted=TRUE)
}
}
\seealso{
Other Graph creation functions: 
\code{\link{Creating_Graphs_GLM}},
\code{\link{brainGraphList}},
\code{\link{make_ego_brainGraph}()}
}
\concept{Graph creation functions}
