% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanConnection.R
\name{meanConnection}
\alias{meanConnection}
\title{Calculate percentage of connection in all pairwise brain regions.}
\usage{
meanConnection(path = getwd(), threshold = 0.2)
}
\arguments{
\item{path}{the path where csv files located}

\item{threshold}{the threshold for significance of percentage of
connection (if percentage exceeds threhold, then
the region pair is significant). Typically, it can be 15-30\%.}
}
\value{
the object containing significant regions.
}
\description{
This function can create a list of significant (threshold is defined by user) region pairs.
}
\details{
you need to specify the path where csv files
(containing KCCA information)locoated. This function
will read all csv files listed in the path.
}
\examples{
\donttest{
#It will take more than 3 min to run
filePath <- tempdir()
#the nii.gz fMRI imaging file is created (toy example)
oro.nifti::writeNIfTI(brainKCCA::input_img, paste(filePath, "/",  "temp", sep=""))
#read fMRI data
testcase1 <- nii2RData(niiFile1 = "temp", resolution = "3mm", imgPath = filePath)
result1<-permkCCA_multipleRegion(imageDat = testcase1, region = c(1,5,10))
summary_result1 <- summary_kcca(kcca_object=result1, saveFormat = "excel")
write.csv(summary_result1, paste(filePath, "/",  "temp.csv", sep=""))
summary_data <- meanConnection(path = filePath, threshold=0.25)
multipleRegion_plot(summary_data, significance=NA)
}
}
\author{
Xubo Yue, Chia-Wei Hsu (tester), Jian Kang (maintainer)
}
