% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm_kCCA.R
\name{perm_kCCA}
\alias{perm_kCCA}
\alias{perm_kCCA_par}
\title{Calculation of Strength of the Connectivity among Multiple Brain Regions}
\usage{
perm_kCCA(x, y, sig = 0.1, gama = 0.1, ncomps = 1, permNum = 50,
  kernel = "rbfdot")

perm_kCCA_par(x, y, sig = 0.1, gama = 0.1, ncomps = 1, permNum = 500,
  kernel = "rbfdot")
}
\arguments{
\item{x}{region 1, a matrix containing data index by row.}

\item{y}{region 2, a matrix containing data index by row.}

\item{sig}{inverse kernel width for the Radial Basis kernel function
"rbfdot" and the Laplacian kernel "laplacedot".}

\item{gama}{regularization parameter (default: 0.1).}

\item{ncomps}{number of canonical components (default: 1).}

\item{permNum}{number of permutation (default 50).}

\item{kernel}{type of kernel.}
}
\value{
(lists of) list of region index, p-value, region type ("two" or "multiple"),
and region name.
}
\description{
This function is the core part for kernel canonical correlation analysis.
Generally you do not need to use this function unless you are famaliar with kcca
algorithm.
}
\details{
Kernel canonical correlation analysis (KCCA) can explore the
nonlinear relationship between two variables.
It transformed sample vectors into the Hilbert space and maximize
correlation coefficient by solving quadratically regularized Lagrangean function.
Refer to Kang's paper for more details: Kang J, Bowman FD, Mayberg H, Liu H (2016).
"A depression network of functionallyconnected regions discovered via multi-attribute
canonical correlation graphs."NeuroImage,141, 431-441.
}
\references{
\url{https://www.ncbi.nlm.nih.gov/pubmed/27474522}
}
\author{
Xubo Yue, Chia-Wei Hsu (tester), Jian Kang (maintainer)
}
