% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov.R
\name{bratteliDimensions}
\alias{bratteliDimensions}
\title{Bratteli dimensions}
\usage{
bratteliDimensions(Mn, N)
}
\arguments{
\item{Mn}{a function returning for each integer \code{n} the incidence
matrix between levels \code{n} and \code{n+1}; the matrix \code{Mn(0)}
must have one and only one row}

\item{N}{the level up to which the dimensions are wanted}
}
\value{
The dimensions of the vertices in a list.
}
\description{
Dimensions of the vertices of a Bratteli graph.
}
\examples{
# the Pascal graph ####
Pascal <- function(n) {
 M <- matrix(0, nrow = n+1, ncol = n+2)
 for(i in 1:(n+1)) {
   M[i, ][c(i, i+1L)] <- 1
 }
 M
}
bratteliDimensions(Pascal, 4)

# the Euler graph ####
Euler <- function(n) {
  M <- matrix(0, nrow = n+1, ncol = n+2)
  for(i in 1:(n+1)) {
    M[i, ][c(i, i+1L)] <- c(i, n+2-i)
  }
  M
}
bratteliDimensions(Euler, 4)
}
