% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brglmFit.R
\name{vcov.brglmFit}
\alias{vcov.brglmFit}
\title{Return the variance-covariance matrix for the regression parameters
in a \code{\link[=brglmFit]{brglmFit()}} object}
\usage{
\method{vcov}{brglmFit}(object, model = c("mean", "full", "dispersion"), complete = TRUE, ...)
}
\arguments{
\item{object}{
    a fitted model object, typically.  Sometimes also a
    \code{\link{summary}()} object of such a fitted model.
  }

\item{model}{character specifying for which component of the model coefficients should be extracted.}

\item{complete}{for the \code{aov}, \code{lm}, \code{glm}, \code{mlm}, and where
    applicable \code{summary.lm} etc methods: logical indicating if the
    full variance-covariance matrix should be returned also in case of
    an over-determined system where some coefficients are undefined and
    \code{\link[stats]{coef}(.)} contains \code{NA}s correspondingly.   When
    \code{complete = TRUE},  \code{vcov()} is compatible with
    \code{coef()} also in this singular case.}

\item{...}{
    additional arguments for method functions.  For the
    \code{\link[stats]{glm}} method this can be used to pass a
    \code{dispersion} parameter.}
}
\description{
Return the variance-covariance matrix for the regression parameters
in a \code{\link[=brglmFit]{brglmFit()}} object
}
\details{
The options for \code{model} are \code{"mean"} for mean regression parameters
only (default), \code{"dispersion"} for the dispersion parameter (or the
transformed dispersion; see \code{\link[=brglm_control]{brglm_control()}}), and \code{"full"} for
both the mean regression and the (transformed) dispersion
parameters.
}
