% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-halflife_SD.R
\name{BridgeRGrubbsTest}
\alias{BridgeRGrubbsTest}
\title{RNA half-life Grubbs test.}
\usage{
BridgeRGrubbsTest(controlFile, compFile, hour = c(0, 1, 2, 4, 8, 12),
  controlGroup = c("CTRL_PUM1", "CTRL_PUM2", "CTRL_DKD"), inforColumn = 4,
  compIndex = 2, save = T, outputPrefix = "BridgeR_8")
}
\arguments{
\item{controlFile}{The dataframe of halflife table.}

\item{compFile}{The dataframe of RPKM table.}

\item{hour}{The vector of time course about BRIC-seq experiment.}

\item{controlGroup}{The vector of group names.}

\item{inforColumn}{The number of information columns.}

\item{compIndex}{The number of information columns.}

\item{save}{Whether to save the output matrix file.}

\item{outputPrefix}{The prefix for the name of the output.}
}
\value{
data.table object about Grabbs test result.
}
\description{
\code{BridgeRGrubbsTest} calculates the p-value for each gene
 using grubbs test. The estimation is based on the standard deviation of
 RNA half-lives in control conditions.
}
\examples{
group <- c("Control", "Knockdown")
hour <- c(0, 1, 2, 4, 8, 12)
half_sd_table <- CalcHalflifeDeviation(halflife_table,
                                       RNA_halflife_grubbs_test,
                                       group = c("CTRL_1",
                                                 "CTRL_2",
                                                 "CTRL_3"),
                                       save = FALSE)
grubbs_table <- BridgeRGrubbsTest(half_sd_table,
                                  halflife_table,
                                  compIndex = 4,
                                  controlGroup = c("CTRL_1",
                                                   "CTRL_2",
                                                   "CTRL_3"),
                                  save = FALSE)

}

