% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_data.R
\name{matrix_to_dataset}
\alias{matrix_to_dataset}
\title{Convert data to torch format}
\usage{
matrix_to_dataset(x, y)
}
\arguments{
\item{x}{A numeric matrix of predictors.}

\item{y}{A vector. If regression than \code{y} is numeric. For classification, it
is a factor.}
}
\value{
An R6 index sampler object with classes "training_set",
"dataset", and "R6".
}
\description{
For an x/y interface, \code{matrix_to_dataset()} converts the data to proper
encodings then formats the results for consumption by \code{torch}.
}
\details{
Missing values should be removed before passing data to this function.
}
\examples{
\dontshow{if (!brulee:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (torch::torch_is_installed()) {
  matrix_to_dataset(as.matrix(mtcars[, -1]), mtcars$mpg)
}
\dontshow{\}) # examplesIf}
}
