% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_starter_pack.R
\name{bs_new_starter_pack}
\alias{bs_new_starter_pack}
\title{Create a new starter pack}
\usage{
bs_new_starter_pack(
  name,
  list,
  description,
  feeds,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{name}{Character. Display name for starter pack}

\item{list}{Character. List to base the starter pack on. If not provided,
a new list will be created.}

\item{description}{Optional character. Description of the list.}

\item{feeds}{Optional character. List of feed items to include in starter pack.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of post information
}
\description{
Create a new starter pack
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/starterpack.json}{graph/starterpack.json (2024-12-04)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/createRecord.json}{repo/createRecord.json (2023-11-25)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-12-04)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_new_starter_pack('bskyr test')
\dontshow{\}) # examplesIf}
}
\concept{record}
