% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bspline.R
\name{imat}
\alias{imat}
\title{Integration matrix of B-spline}
\usage{
imat(nqw = NULL, xk = NULL, n = NULL, f = NULL)
}
\arguments{
\item{nqw}{Integer scalar, row number of qw matrix (i.e. degree of freedom of a B-spline)}

\item{xk}{Numeric vector, knot positions}

\item{n}{Integer scalar, B-spline polynomial order}

\item{f}{Function from which previous parameters can be retrieved.
If both f and any of previous parameters are given then explicitly
set parameters take precedence over those retrieved from f.}
}
\value{
Numeric matrix of size \code{nqw+1 x nqw}
}
\description{
Calculate matrix for obtaining coefficients of indefinite integral of B-spline.
They can be calculated as \code{iqw=Mi \%*\% qw}. Here, iqw are coefficients
of the indefinite integral of B-spline,
Mi is the matrix returned by this function, and qw are the coefficients
of integrated B-spline.\cr
As per the nature of the indefinite integral, this coefficients are defined up to
arbitrary additive constant.\cr
}
