
#' Cigarette demand
#'
#' Panel dataset on cigarette demand in 46 US states from 1963 until 1992,
#' see Baltagi and Levin (1992) and Baltagi and Li (2004). Extended with
#' longitude and latitude from the \code{us_states} dataset.
#'
#' @docType data
#'
#' @format A \code{data.frame} object.
#'
#' @references
#'   Baltagi, B. H. and Levin, D. (1992). Cigarette taxation: raising revenues
#'   and reducing consumption, \emph{Structural Change and Economic Dynamics},
#'   \bold{3(2)}, 321-335. \doi{10.1016/0954-349X(92)90010-4}.
#'   Baltagi, B. H. and Li, D. (2004). Prediction in the panel data model with
#'   spatial correlation. \emph{Advances in Spatial Econometrics}, 283-295.
#'   Springer, Berlin. \doi{10.1007/978-3-662-05617-2_13}.
"cigarettes"


#' United States Historical States
#'
#' Polygons of US state boundaries for the period 1960--2000. Subset from
#' Siczewicz (2011). Licensed under CC BY-NC-SA 2.5 by the Atlas of Historical
#' County Boundaries.
#'
#' @docType data
#'
#' @format A \code{sf} object.
#'
#' @references
#'   Siczewicz, P. (2011) U.S. Historical States and Territories (Generalized
#'   0.01 deg). Dataset. Atlas of Historical County Boundaries, edited by
#'   Long, J. H. . Chicago: The Newberry Library, 2011. Available online from
#'   \url{https://publications.newberry.org/ahcbp/}.
#'
#' @source \url{https://publications.newberry.org/ahcbp/}
"us_states"
