% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaming_link_object.R
\name{alllinks}
\alias{alllinks}
\title{Return a list of all linked pairs (directly or transitively)}
\usage{
alllinks(sl, idx = c("global", "local"))
}
\arguments{
\item{sl}{A streaming link object}

\item{idx}{Whether to use global (default) or local indices}
}
\value{
A list with two (global) or four (local) members, defining linked
pairs of records. If 'global' indices, these members are called 'idx1' and
'idx2', where corresponding entries are the global indices of matched pairs
of records. If 'local' indices, these members are called 'file1', 'record1',
'file2', and 'record2', where corresponding entries are the file number and
record number within the file of matched pairs of records.
}
\description{
Return a list of all linked pairs (directly or transitively)
}
\examples{
data(geco_small_result)
samples <- extractlinks(geco_small_result)
# List all linked pairs of records in the 42nd posterior sample
alllinks(samples[[42]], idx="global")
alllinks(samples[[42]], idx="local")

}
