% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_structural_shocks.R
\name{compute_structural_shocks.PosteriorBSVART}
\alias{compute_structural_shocks.PosteriorBSVART}
\title{Computes posterior draws of structural shocks}
\usage{
\method{compute_structural_shocks}{PosteriorBSVART}(posterior)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBSVART} obtained by running the \code{estimate} function.}
}
\value{
An object of class PosteriorShocks, that is, an \code{NxTxS} array 
with attribute PosteriorShocks containing \code{S} draws of the structural shocks.
}
\description{
Each of the draws from the posterior estimation of models from
packages \pkg{bsvars} or \pkg{bsvarSIGNs} is transformed into
a draw from the posterior distribution of the structural shocks.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar_t$new(us_fiscal_lsuw, p = 1)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20)

# compute structural shocks
shocks         = compute_structural_shocks(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_t$new(p = 1) |>
  estimate(S = 10) |> 
  estimate(S = 20) |> 
  compute_structural_shocks() -> ss

}
\seealso{
\code{\link{estimate}}, \code{\link{normalise_posterior}}, \code{\link{summary}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
