% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.PosteriorHD}
\alias{summary.PosteriorHD}
\title{Provides posterior summary of historical decompositions}
\usage{
\method{summary}{PosteriorHD}(object, ...)
}
\arguments{
\item{object}{an object of class PosteriorHD obtained using the
\code{compute_historical_decompositions()} function containing posterior draws
 of historical decompositions.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior means of historical decompositions for
each of the variables.
}
\description{
Provides posterior means of the historical decompositions variable
by variable.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar$new(diff(us_fiscal_lsuw))

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20)

# compute historical decompositions
hds            = compute_historical_decompositions(posterior)
hds_summary    = summary(hds)

# workflow with the pipe |>
############################################################
set.seed(123)
diff(us_fiscal_lsuw) |>
  specify_bsvar$new() |>
  estimate(S = 10) |> 
  estimate(S = 20) |> 
  compute_historical_decompositions() |>
  summary() -> hds_summary

}
\seealso{
\code{\link{compute_historical_decompositions}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
