% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/16_zLongSyntheticFuture.R
\name{zLongSyntheticFuture}
\alias{zLongSyntheticFuture}
\title{Calculates Profit and Loss (PnL) per unit of the underlying and Breakeven point at expiration for Long Synthetic Future and draws its graph in the Plots tab.}
\usage{
zLongSyntheticFuture(
  STF,
  XF,
  COF,
  POF,
  hl = 0,
  hu = 2,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = " Long Synthetic Future ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{STF}{Future contract price at time T.}

\item{XF}{Strike Price of Option on Future.}

\item{COF}{Call Premium paid on buying an Option on Future  .}

\item{POF}{Put premium received on shorting an Option on Future.}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Long Synthetic Future.
}
\description{
This strategy results from buying a call of the option on Future and selling a put of the option on the Future of the same strike price with the same expiration. On initiation, this is a net debit Strategy and results in net cash inflow as premium received on shorting a put of the option on Future is less than premium paid on buying a call of the option on Future (Kakushadze & Serur, 2018). This Strategy precisely mimics the long future position (Cohen, 2015).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss (per unit of the underlying)  at expiration and Breakeven (BE) point for Long Synthetic Future and draws its graph in the Plots tab.
}
\examples{
zLongSyntheticFuture(12,14,4,2)
zLongSyntheticFuture(200,205,7,2,hl=0.95,hu=1.15)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
