% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_point_estimate.R
\name{get_point_estimate}
\alias{get_point_estimate}
\title{Calculate the marginal treatment effects (only the point estimate) for hazard ratio (HR) adjusting covariates in clinical trials}
\usage{
get_point_estimate(
  trt,
  cox_event,
  cox_censor,
  data,
  M = 1000,
  seed = NULL,
  cpp = TRUE,
  control = clmqControl(),
  verbose = TRUE
)
}
\arguments{
\item{trt}{Character. Variable name of the treatment assignment. Only support two arm trial at the moment.}

\item{cox_event}{Object. A coxph model using the survival time and survival status.}

\item{cox_censor}{Object. A coxph model using the survival time and 1-survival status.}

\item{data}{A data frame used for cox_event and cox_censor.}

\item{M}{Numeric. The number of simulated counterfactual patients. Suggest to set a large M to get robust estimation but this will be time comsuming.}

\item{seed}{Numeric. Random seed for simulation.}

\item{cpp}{Bool. True for using C++ optimization. False for not using C++ optimization. This requires cpp package installed.}

\item{control}{Named list. A list containing control parameters, including memory of remote workers, whether to use nested parallel computation or local multiprocess, number of remote workers/jobs, etc. See details of \link[bunsen]{clmqControl}.}

\item{verbose}{Bool. Print status messages. Default: TRUE}
}
\value{
The marginal beta (logHR)
}
\description{
This function only estimates the marginal logHR. For a complete estimation including the standard error, see \link[bunsen]{get_marginal_effect}.
}
\details{
Use the simulation approach from Daniel et al. (2020) to estimate the marginal HR when adjusting covariates.
This function uses the parallel computation via remote LSF and local multiprocess. Additional
feature also includes the C++ optimization that can speed up the calculation.
}
\examples{
library(survival)
data("oak")

cox_event <- coxph(Surv(OS, os.status) ~ trt + btmb + pdl1, data = oak)
#
cox_censor <- coxph(Surv(OS, 1 - os.status) ~ trt + btmb + pdl1, data = oak)
#
get_point_estimate(
  trt = "trt", cox_event = cox_event, cox_censor, M = 1000, data = oak,
  seed = 1, cpp = FALSE, control = clmqControl(clmq_hr=FALSE)
)
}
\references{
Daniel R, Zhang J, Farewell D. Making apples from oranges:
Comparing noncollapsible effect estimators and their standard errors
after adjustment for different covariate sets.
Biom J. 2021;63(3):528-557. doi:10.1002/bimj.201900297
}
