% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first_last.R
\name{first_last}
\alias{first_last}
\title{Shortcut for lists with steady transactions.}
\usage{
first_last(years, value)
}
\arguments{
\item{years}{Integer vector, at least two elements, the range of years to cover.}

\item{value}{The transaction amount that is assumed to remain unchanged over all \code{years}.}
}
\value{
A list with two elements named after the first and last month of the \code{years}' range
   in \code{YYYY.MM} format.
}
\description{
Generates a list of two elements, first and last month of the full years range, both
with the same value specified.
}
\details{
You can use this in combination with the \code{.list} argument of
\code{\link[businessPlanR:expense]{expense}},
      \code{\link[businessPlanR:revenue]{revenue}}, and
\code{\link[businessPlanR:transaction]{transaction}}.
}
\examples{
expense(
    type="Operation",
    category="Bank",
    name="Accounting",
    missing="rep",
    .list=first_last(2022:2025, value=20)
)
}
