% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_class_05_loan.R
\docType{class}
\name{loan,-class}
\alias{loan,-class}
\alias{loan}
\alias{loan-class}
\alias{initialize,loan-method}
\title{S4 Class loan}
\usage{
\S4method{initialize}{loan}(
  .Object,
  type,
  category,
  name,
  amount,
  period,
  interest,
  first_month = format(Sys.Date(), "\%Y.\%m"),
  schedule = c("annuity", "amortization", "maturity"),
  due_month = NA,
  valid_types = "default",
  value
)
}
\arguments{
\item{.Object}{The object to initialize.}

\item{type}{A character string defining the type of transaction as defined by \code{valid_types}.}

\item{category}{A character string, custom category for this transaction.}

\item{name}{A character string, custom name or ID for this transaction.}

\item{amount}{Numeric, the amount of money loaned.}

\item{period}{Integer, number of months to fully repay the loan.}

\item{interest}{Numeric, the nominal interest rate per annum (a value between 0 and 1).}

\item{first_month}{Character string in \code{YYYY.MM} format,
      defining the initial date of the loan.}

\item{schedule}{One of the following, defining the repayment schedule:
\itemize{
    \item{\code{"annuity"}: }{Equal rates of total repayment over \code{period},
      thereby interest is relatively higher
        and principal payment relatively lower at the beginning.}
    \item{\code{"amortization"}: }{Repayment of equal rates of principal payment with decreasing interest and total payments over \code{period}.}
    \item{\code{"maturity"}: }{Repayment of the full loan amount at the end of \code{period},
      until then only payment of interest.}
}}

\item{due_month}{Integer value defining the first month of principal repayment. The selected \code{schedule} will not begin before this month,
until then only interest rates are due.
Beware that this is a different behaviour of this argument compared to \code{\link[businessPlanR:transaction-class]{transaction}}.}

\item{valid_types}{A character string,
      the model types defined by \code{\link[businessPlanR:set_types]{set_types}} to be used for validation.
If \code{"default"}, pre-defined example types are used.}

\item{value}{A valid data frame to be used as the value slot directly,
      omitting calculation via \code{amount}, \code{period}, \code{interest}, etc.}
}
\description{
This is a special case of the generic class \code{\link[businessPlanR:transaction-class]{transaction}}.
}
\details{
In contrast to \code{\link[businessPlanR:revenue-class]{revenue}} or \code{\link[businessPlanR:expense-class]{expense}},
the time range of this class of objects is defined by details of the loan as specified. Only when used as
an aspect of an \code{\link[businessPlanR:operations-class]{operations}} class object,
      this range is adjusted
to fit that particular object.
}
\section{Slots}{

\describe{
\item{\code{type}}{A character string,
      for valid values see \code{valid_types}. You might use all valid types pre-defined for either
\code{revenue} or \code{expense},
      considering that you might be the loan giver or receiver.}

\item{\code{category}}{A character string, custom category for this loan.}

\item{\code{name}}{A character string, custom name or ID for this loan.}

\item{\code{value}}{Data frame containing an amortization schedule for the loan,
      each month in a row named \code{YYYY.MM}.
It has a row for each month and the columns \code{balance_start}, \code{interest},
      \code{principal}, \code{total},
\code{cumsum}, and \code{balance_remain}.}

\item{\code{valid_types}}{A character string, the model types defined by
\code{\link[businessPlanR:set_types]{set_types}} to be used for validation.}
}}

\section{Constructor function}{

Should you need to manually generate objects of this class, the constructor function 
\code{loan(...)} can be used instead of
\code{new("loan", ...)}.
}

\section{NA}{

Should you need to manually generate objects of this class, the constructor function 
\code{loan(...)} can be used instead of
\code{new("loan", ...)}.
}

\examples{
loan_2019 <- loan(
    type="Interest",
    category="Bank",
    name="New office",
    amount=10000,
    period=60,
    interest=0.075,
    first_month="2019.04",
    schedule=c("amortization")
)

# turn loan object into an expense
loan_as_expense_2019 <- as_transaction(
    loan_2019,
    to="expense",
    aspect="interest"
)
}
\keyword{classes}
