% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confIntv3.R
\name{conf.intv3}
\alias{conf.intv3}
\title{Observed Fisher information based confidence interval of 3-parameter Block-Basu
Bivariate Pareto (BBBVPA) distribution}
\usage{
conf.intv3(object, conf.lev = 0.95, tol = 1e-04)
}
\arguments{
\item{object}{\code{"bbbvpa"} class object.}

\item{conf.lev}{confidence level, \eqn{0.95} (default).}

\item{tol}{convergence tolerance for confidence intervals, \code{0.0001} (default).}
}
\value{
A matrix of lower and upper confidence interval limits (in the first and second column respectively).
The matrix rows are labeled by the parameter names (if any) and columns by the corresponding
distribution quantiles.
}
\description{
Observed Fisher information based confidence interval of 3-parameter BBBVPA distribution.
}
\examples{
dat <- rbb.bvpa(500, 0, 0, 1.0, 1.0, 2.0, 0.4, 0.5)
conf.intv3(estimates3(dat, 2.4, 0.3, 0.6))

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
