% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation3.R
\name{estimates3}
\alias{estimates3}
\title{Estimation of 3-parameter Block-Basu Bivariate Pareto (BBBVPA) distribution}
\usage{
estimates3(
  I,
  a0.int,
  a1.int,
  a2.int,
  tol.est = 1e-05,
  MxIter.no = 2000,
  condition = "log.L"
)
}
\arguments{
\item{I}{bivariate observations.}

\item{a0.int}{initial choice of \eqn{\alpha_0}.}

\item{a1.int}{initial choice of \eqn{\alpha_1}.}

\item{a2.int}{initial choice of \eqn{\alpha_2}.}

\item{tol.est}{convergence tolerance, \code{0.0001} (default).}

\item{MxIter.no}{maximum number of iterations, \code{2000} (default).}

\item{condition}{convergence criterion, \code{"log.L"} (default) and \code{"p.logL"}.}
}
\value{
Object of class "\code{bbbvpa3}", a list consisting of
\item{alpha0, alpha1, alpha2, iter.no}{estimates  of parameters and number of iteration.}
\item{data }{the supplied data \code{I}.}
}
\description{
Parameters estimation of 3-parameter BBBVPA distribution.
}
\examples{
dat <- rbb.bvpa(500, 0, 0, 1.0, 1.0, 2.0, 0.4, 0.5)
estimates3(dat, 2.4, 0.3, 0.6)[-5]

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
