% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_metrics.R
\name{class_purity}
\alias{class_purity}
\title{Calculate cluster purity per class}
\usage{
class_purity(conf_mat)
}
\arguments{
\item{conf_mat}{A confusion matrix from \code{\link[c2c]{get_conf_mat}} or otherwise (ideally a matrix, although data frames will probably work)}
}
\value{
A data frame with two columns, the first corresponding to the confusion matrix rows, the second corresponding to the confusion matrix columns.
}
\description{
Used to calculate cluster purity from a confusion matrix, for each class (i.e. each row and column of the confusion matrix).
}
\details{
Metrics per class are useful when you are comparing two classifications with different numbers of classes, when an overall measure might not be useful or sensible. Purity as defined in Manning (2008).
}
\references{
Manning, C. D., Raghavan, P., & Schütze, H. (2008) Introduction to information retrieval (Vol. 1, No. 1). Cambridge: Cambridge university press.
}
