% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c3.R
\name{c3}
\alias{c3}
\title{C3}
\usage{
c3(data, x = NULL, y = NULL, group = NULL, width = NULL,
  height = NULL, axes = NULL, labels = NULL, hide = NULL,
  onclick = NULL, onmouseover = NULL, onmouseout = NULL, ...)
}
\arguments{
\item{data}{data.frame or tibble}

\item{x}{character column name}

\item{y}{character column name}

\item{group}{character column name}

\item{width}{integer htmlwidget width (separate from plot width)}

\item{height}{integer htmlwidget height (separate from plot height)}

\item{axes}{list, use to assign plot elements to secondary y axis}

\item{labels}{character or list with options:
 \itemize{
 \item{format}{: list format functions for each parameter label (see \href{http://c3js.org/reference.html#data-labels}{c3 data-labels})}
}}

\item{hide}{boolean or character vector of parameters to hide}

\item{onclick}{character js function, wrap character or character vector in JS()}

\item{onmouseover}{character js function, wrap character or character vector in JS()}

\item{onmouseout}{character js function, wrap character or character vector in JS()}

\item{...}{addition options passed to the data object}
}
\description{
An `R` wrapper, or \href{http://www.htmlwidgets.org/}{htmlwidget}, for the \href{http://c3js.org/}{c3} javascript charting library by \href{https://github.com/masayuki0812}{Masayuki Tanaka}.
}
\examples{
data <- data.frame(a = c(1,2,3,2), b = c(2,3,1,5))

data \%>\%
  c3(onclick = htmlwidgets::JS("function(d, element){console.log(d)}"))

data \%>\%
  c3(axes = list(a = 'y',
                 b = 'y2')) \%>\%
  y2Axis()

data.frame(sugar = 20, fat = 45, salt = 10) \%>\%
  c3(onclick = htmlwidgets::JS("function(d, element){dp = d}")) \%>\%
  c3_pie()

}
\seealso{
Other c3: \code{\link{RColorBrewer}}, \code{\link{grid}},
  \code{\link{legend}}, \code{\link{region}},
  \code{\link{subchart}}, \code{\link{tooltip}},
  \code{\link{xAxis}}, \code{\link{zoom}}
}
\concept{c3}
