% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cabinets.R
\name{new_cabinet_proj}
\alias{new_cabinet_proj}
\title{Create a new project using a cabinet template}
\usage{
new_cabinet_proj(
  cabinet,
  project_name,
  r_project = TRUE,
  open = TRUE,
  renv = TRUE,
  git = TRUE,
  git_root = NULL,
  git_ignore = NULL
)
}
\arguments{
\item{cabinet}{The name of the cabinet template. Available cabinets can
be found using \code{get_cabinets()}.}

\item{project_name}{The name of the project to store in the cabinet,
a character string. Can be a file path pointing to a directory
within the specified cabinet.}

\item{r_project}{Logical, should an Rproject be created. Default is
TRUE if working in RStudio (only works in RStudio).}

\item{open}{Logical, if creating an Rproject, should that project
be opened once created. Default is TRUE if working in
RStudio (only works in RStudio).}

\item{renv}{Logical, should a \code{renv} project be initiated.
If \code{TRUE}, \code{renv} project infrastructure will be created using
\code{\link[renv]{scaffold}}.}

\item{git}{Logical, should a git repository be initiated.}

\item{git_root}{A path relative to the project to initiate the
git repository. Default is NULL and the repository is
initiated at the root of the project.}

\item{git_ignore}{Character vector of files and directories
to add to .gitignore file.}
}
\value{
Creates a new directory at the path specified in the
 cabinet template. If \code{r_project = TRUE}, a .Rproj file
 will also be created using the project name. If open is set
 to TRUE, the new R project will opened in a new R session.
}
\description{
Generate new project directories using cabinet templates.
}
\seealso{
\code{\link{create_cabinet}}
}
