% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineclassesandfunctions.R
\name{reordercategories}
\alias{reordercategories}
\title{Reorder categories for chosen variable in MCA case only}
\usage{
reordercategories(x, varno, newcats)
}
\arguments{
\item{x}{An object of class \code{\linkS4class{cabootcrsresults}}}

\item{varno}{The number of the variable to be reordered}

\item{newcats}{A vector of length equal to the number of categories for this variable,
giving the new order for the categories
(e.g. c(4,1,2,3) means that the original 4th category is moved to first)}
}
\value{
An object of class \code{\linkS4class{cabootcrsresults}}
}
\description{
\code{reordercategories} reorders the principal and standard coordinates, CTR, REP,
variances and covariances of the categories for a single MCA variable
}
\details{
This may be useful when comparing results between different data sets or from different packages

Note: does not reorder anything in the \code{\linkS4class{cabasicresults}}
part of the \code{\linkS4class{cabootcrsresults}} object
}
\examples{
bd3 <- cabootcrs(DreamData223by3, catype="mca", nboots=0, showresults=FALSE)
bd3reorderedvar2 <- reordercategories(bd3, 2, c(3,2,4,1))
summaryca(bd3)
summaryca(bd3reorderedvar2)

\dontrun{

# Can be used when comparing results in different packages,
# or when adding ellipses from this package to output from others

library(FactoMineR)
library(ca)
data(tea)
# remove duplicated age variable
teamod <- tea[,c(1:18,20:36)]

# ca package uses standardised coordinates and inertias by default
catea <- mjca(teamod)
btea <- cabootcrs(teamod, catype="mca", showresults=FALSE, nboots=0, varandcat=FALSE)

# FactoMineR package uses unstandardised coordinates and inertias by default
fmtea <- MCA(teamod, method="Burt", graph=FALSE)
bteaunstd <- cabootcrs(teamod, catype="mca", showresults=FALSE, nboots=0,
                       mcaadjustinertias = FALSE, mcaadjustcoords = FALSE, varandcat=FALSE)

summary(fmtea)
summaryca(bteaunstd)
summary(catea)
summaryca(btea)

# slight difference due to different orderings of categories for these two
fmtea$var$coord / bteaunstd@Colprinccoord[,1:5]
catea$colpcoord[,1:5] / btea@Colprinccoord[,1:5]
fmtea$var$coord / catea$colpcoord[,1:5]

# Variables 22 and 23, in columns 57-65, are the problem
# The coordinates agree (apart from reflection) but the categories are in a different order
fmtea$var$coord[57:65,1:3]
bteaunstd@Colprinccoord[57:65,1:3]

catea$colpcoord[57:65,1:3]
btea@Colprinccoord[57:65,1:3]

# Coordinates agree when categories reordered and axes reflected
bteaunstdreord <- reordercategories(bteaunstd,22,c(2:5,1))
bteaunstdreord <- reordercategories(bteaunstdreord,23,c(3,2,1,4))
bteaunstdreordreflect <- reflectaxes(bteaunstdreord,c(1,4))
fmtea$var$coord / bteaunstdreordreflect@Colprinccoord[,1:5]

bteareord <- reordercategories(btea,22,c(2:5,1))
bteareord <- reordercategories(bteareord,23,c(3,2,1,4))
bteareordreflect <- reflectaxes(bteareord,c(2,5))
catea$colpcoord[,1:5] / bteareordreflect@Colprinccoord[,1:5]

}

}
\seealso{
\code{\link{cabootcrs-package}}, \code{\link{cabootcrs}}, \code{\link{reflectaxes}}, \code{\linkS4class{cabootcrsresults}}
}
