% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hebrew.R
\name{yom_kippur}
\alias{yom_kippur}
\alias{passover}
\alias{purim}
\alias{ta_anit_esther}
\alias{tishah_be_av}
\alias{hanukkah}
\alias{rosh_hashanah}
\alias{sukkot}
\alias{shavuot}
\title{Jewish Holidays}
\usage{
yom_kippur(year)

passover(year)

purim(year)

ta_anit_esther(year)

tishah_be_av(year)

hanukkah(year)

rosh_hashanah(year)

sukkot(year)

shavuot(year)
}
\arguments{
\item{year}{A numeric vector of Gregorian years}
}
\value{
A vector of dates on the Gregorian calendar
}
\description{
Functions to return Gregorian dates for various Jewish holidays
}
\examples{
tibble::tibble(
  year = 2025:2030,
  ta_anit_esther = ta_anit_esther(year),
  purim = purim(year),
  passover = passover(year),
  shavuot = shavuot(year),
  tishah_be_av = tishah_be_av(year),
  rosh_hashanah = rosh_hashanah(year),
  yom_kippur = yom_kippur(year),
  sukkot = sukkot(year),
  hanukkah = hanukkah(year)
)
}
\seealso{
\link{hebrew_date}
}
