% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cervical_hiv_screened.R
\name{get_cervical_hiv_screened}
\alias{get_cervical_hiv_screened}
\title{Retrieves Cervical Cancer Screening Data on HIV Positive Women}
\usage{
get_cervical_hiv_screened(
  start_date,
  end_date = NULL,
  level = c("country", "county", "subcounty", "ward", "facility"),
  organisations = NULL,
  ...
)
}
\arguments{
\item{start_date}{The start date to retrieve data. It is required and in the format \code{YYYY-MM-dd}.}

\item{end_date}{The ending date for data retrieval (default is the current date).}

\item{level}{The desired data granularity: \code{"country"} (the default), \code{"county"}, \code{"subcounty"}, \code{"ward"}, or \code{"facility"}.}

\item{organisations}{A list of organization units ids to be filtered.}

\item{...}{Other options that can be passed onto KHIS API.}
}
\value{
A tibble containing cervical cancer screening data on HIV positive women
with the following columns:
\itemize{
\item country    - Name of the country.
\item county     - Name of the county. Optional if the level is \code{county}, \code{subcounty}, \code{ward} or \code{facility}.
\item subcounty  - Name of the subcounty. Optional if the level is \code{subcounty}, \code{ward} or \code{facility}.
\item ward       - Name of the ward. Optional if the level is \code{ward} or \code{facility}.
\item facility   - Name of the health facility. Optional if the level \code{facility}.
\item period     - The month and year of the data.
\item fiscal_year- The financial year of the report(July-June Cycle).
\item year       - The calendar year of the report.
\item month      - The month name of the report.
\item category   - The age group category of the report (<25, 25-49, 50+).
\item category2  - Additional category if available.
\item element    - The data element (HPV, VIA or Pap Smear).
\item source     - The source report (MOH 711 or MOH 745).
\item value      - The number reported.
}
}
\description{
\code{get_cervical_hiv_screened()} retrieves cervical cancer screening and positivity
data for HIV positive women for a specified period from the KHIS API server.
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download data from February 2023 to current date
screened <- get_cervical_hiv_screened(start_date = '2023-02-01')
screened
\dontshow{\}) # examplesIf}
}
