% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_parquet.R
\name{remove_cansim_cached_tables}
\alias{remove_cansim_cached_tables}
\title{Remove cached cansim SQLite and parquet database}
\usage{
remove_cansim_cached_tables(
  cansimTableNumber,
  format = c("parquet", "feather", "sqlite"),
  language = NULL,
  cache_path = Sys.getenv("CANSIM_CACHE_PATH")
)
}
\arguments{
\item{cansimTableNumber}{Vector of the table(s) to be removed, or a (filtered) table as returned by `list_cansim_cached_tables`
with the list of tables to be removed.}

\item{format}{Format of cache to remove, possible values are `"parquet"`, `"feather"` or `"sqlite"` or a subset of these (the default is all of these)}

\item{language}{Language for which to remove the cached data. If unspecified (`NULL`) tables for all languages will be removed.}

\item{cache_path}{Optional, default value is `Sys.getenv('CANSIM_CACHE_PATH')`}
}
\value{
`NULL``
}
\description{
Remove cached cansim SQLite and parquet database
}
\examples{
\dontrun{
con <- get_cansim_connection("34-10-0013", format="parquet")
remove_cansim_cached_tables("34-10-0013", format="parquet")
}
}
