% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{import_capl_data}
\alias{import_capl_data}
\title{Import CAPL-2 data from an Excel workbook.}
\usage{
import_capl_data(file_path = NA, sheet_name = NA)
}
\arguments{
\item{file_path}{A character vector representing the file path to an Excel workbook on the user's local computer
(e.g., "c:/users/user_name/desktop/file.xlsx"). The file path is not case-sensitive.}

\item{sheet_name}{An optional character vector representing the sheet to import from the Excel workbook. If this argument is not set, the first sheet in
the workbook will be imported.}
}
\value{
Returns a data frame if the Excel workbook sheet is successfully imported.
}
\description{
This function imports CAPL-2 data from an Excel workbook on a local computer.
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_character]{validate_character()}}.
}
\examples{
capl_demo_data <- import_capl_data(
  file_path = "c:/users/joel/desktop/capl_demo_data.xlsx",
  sheet_name = "Sheet1"
)

str(capl_demo_data)

# tibble [500 x 60] (S3: tbl_df/tbl/data.frame)
#  $ age                            : num [1:500] 8 9 9 8 12 10 12 10 12 9 ...
#  $ gender                         : chr [1:500] "Male" "Female" "Male" "f" ...
#  $ pacer_lap_distance             : num [1:500] 15 20 20 15 20 15 15 15 15 NA ...
#  $ pacer_laps                     : num [1:500] 23 31 169 50 63 15 32 143 43 182 ...
#  $ plank_time                     : num [1:500] 274 282 9 228 252 110 21 185 6 41 ...
#  $ camsa_skill_score1             : num [1:500] 14 5 6 13 2 9 4 11 5 11 ...
#  $ camsa_time1                    : num [1:500] 34 27 13 35 21 NA NA 16 20 14 ...
#  $ camsa_skill_score2             : num [1:500] 14 5 13 11 14 14 0 4 0 4 ...
#  $ camsa_time2                    : num [1:500] 35 23 14 35 23 23 33 30 29 18 ...
#  $ steps1                         : num [1:500] 30627 27788 8457 8769 14169 ...
#  $ time_on1                       : chr [1:500] "5:13am" "6:13" "6:07" "6:13" ...
#  $ time_off1                      : chr [1:500] "22:00" NA "21:00" "22:00" ...
#  $ non_wear_time1                 : num [1:500] 25 31 33 25 83 67 20 10 49 64 ...
#  $ steps2                         : num [1:500] 14905 24750 30111 21077 15786 ...
#  $ time_on2                       : chr [1:500] "06:00" "5:13am" "6:13" "6:13" ...
#  $ time_off2                      : chr [1:500] "21:00" "23:00" "11:13pm" "23:00" ...
#  $ non_wear_time2                 : num [1:500] 20 82 4 55 1 53 65 47 82 79 ...
#  $ steps3                         : num [1:500] 21972 15827 14130 13132 18022 ...
#  $ time_on3                       : chr [1:500] "07:00" "05:00" "07:48am" NA ...
#  $ time_off3                      : chr [1:500] "11:57pm" NA "08:30pm" NA ...
#  $ non_wear_time3                 : num [1:500] 6 79 23 65 34 15 72 76 60 40 ...
#  $ steps4                         : num [1:500] 28084 27369 14315 9963 6993 ...
#  $ time_on4                       : chr [1:500] "05:00" "6:13" "6:07" NA ...
#  $ time_off4                      : chr [1:500] "08:30pm" "10:57 pm" "22:00" "11:13pm" ...
#  $ non_wear_time4                 : num [1:500] 32 38 74 20 75 22 84 59 42 22 ...
#  $ steps5                         : num [1:500] 14858 21112 16880 11707 20917 ...
#  $ time_on5                       : chr [1:500] "6:07" "6:13" "06:00" "05:00" ...
#  $ time_off5                      : chr [1:500] "11:57pm" "23:00" "8:17pm" "8:17pm" ...
#  $ non_wear_time5                 : num [1:500] 61 64 73 23 82 42 66 38 55 18 ...
#  $ steps6                         : num [1:500] 17705 5564 16459 12235 27766 ...
#  $ time_on6                       : chr [1:500] "06:00" "06:00" NA "6:07" ...
#  $ time_off6                      : chr [1:500] "21:00" NA "10:57 pm" "08:30pm" ...
#  $ non_wear_time6                 : num [1:500] 33 24 89 8 27 56 66 21 14 7 ...
#  $ steps7                         : num [1:500] 11067 13540 12106 18795 15039 ...
#  $ time_on7                       : chr [1:500] "6:07" "6:07" "8:00am" "06:00" ...
#  $ time_off7                      : chr [1:500] "08:30pm" "11:13pm" "8:17pm" "10:57 pm" ...
#  $ non_wear_time7                 : num [1:500] 8 72 4 38 9 32 49 36 34 43 ...
#  $ self_report_pa                 : num [1:500] NA 2 2 4 3 5 NA 7 6 7 ...
#  $ csappa1                        : num [1:500] 1 2 4 2 2 2 3 2 2 3 ...
#  $ csappa2                        : num [1:500] 3 2 1 1 1 1 4 1 4 3 ...
#  $ csappa3                        : num [1:500] 2 3 2 1 NA 1 3 3 4 4 ...
#  $ csappa4                        : num [1:500] 4 1 1 3 4 4 4 4 4 1 ...
#  $ csappa5                        : num [1:500] 4 2 3 2 1 2 2 2 4 1 ...
#  $ csappa6                        : num [1:500] 3 4 1 4 2 2 2 3 4 4 ...
#  $ why_active1                    : num [1:500] 4 3 5 3 1 5 4 1 1 2 ...
#  $ why_active2                    : num [1:500] 5 3 4 2 5 3 5 NA 5 NA ...
#  $ why_active3                    : num [1:500] 3 3 1 4 2 3 4 4 5 3 ...
#  $ feelings_about_pa1             : num [1:500] 4 3 2 2 1 1 3 4 4 2 ...
#  $ feelings_about_pa2             : num [1:500] 5 2 2 3 4 2 4 4 2 5 ...
#  $ feelings_about_pa3             : num [1:500] 2 5 2 5 3 2 2 1 3 5 ...
#  $ pa_guideline                   : num [1:500] 2 3 4 1 2 4 3 2 2 2 ...
#  $ crf_means                      : num [1:500] 1 4 4 2 2 1 2 1 4 1 ...
#  $ ms_means                       : num [1:500] 3 2 1 2 3 1 1 2 4 2 ...
#  $ sports_skill                   : num [1:500] 2 4 4 1 3 1 3 1 4 3 ...
#  $ pa_is                          : num [1:500] 10 1 1 1 1 1 2 1 3 1 ...
#  $ pa_is_also                     : num [1:500] 5 1 4 4 1 7 2 7 2 8 ...
#  $ improve                        : num [1:500] 3 3 9 3 9 9 3 3 3 6 ...
#  $ increase                       : num [1:500] 2 8 3 8 8 1 3 3 8 8 ...
#  $ when_cooling_down              : num [1:500] 4 2 4 2 2 2 2 5 2 2 ...
#  $ heart_rate                     : num [1:500] 5 6 4 4 4 9 4 8 7 4 ...

}
