% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{ZhaoNew_Alloc}
\alias{ZhaoNew_Alloc}
\title{Allocation Function of Zhao's New Design for Binary and Continuous Response}
\usage{
ZhaoNew_Alloc(
  ptsb.X,
  ptsb.Z,
  ptsb.t,
  ptsb.Y,
  ptnow.X,
  ptnow.Z,
  response,
  omega,
  p = 0.8
)
}
\arguments{
\item{ptsb.X}{a vector of length \code{n} of the predictive covariates of previous patients. Must be binary.}

\item{ptsb.Z}{a \code{n x k}  of the prognostic covariates of previous patients. Must be binary.}

\item{ptsb.t}{a vector of length \code{n} of the treatment allocation of previous patients.}

\item{ptsb.Y}{a vector of length \code{n} of the responses of previous patients.}

\item{ptnow.X}{a binary value of the predictive covariate of the present patient.}

\item{ptnow.Z}{a vector of length \code{k} of the prognostic covariate of the present patient.}

\item{response}{the type of the response. Options are \code{"Binary"} or \code{"Cont"}.}

\item{omega}{a vector of length \code{2+k}. The weight of imbalance.}

\item{p}{a positive value between 0.75 and 0.95. The probability parameter of Efron's biased coin design.}
}
\value{
\item{prob}{Probability of assigning the upcoming patient to treatment A.}
}
\description{
Calculating the probability of assigning the upcoming patient to treatment A based on the patient's predictive covariates and the previous patients' predictive covariates and responses for Zhao's New procedure.
}
\details{
This function implements a stratified covariate-adjusted response-adaptive design that balances treatment allocation within and across strata defined by prognostic covariates.

The first \eqn{2K} patients are randomized using a restricted randomization procedure, with \eqn{K} patients assigned to each treatment. For patient \eqn{n > 2K}, let \eqn{\mathbf{X}_n} denote predictive covariates, and \eqn{\mathbf{Z}_n} denote stratification covariates, placing the patient into stratum \eqn{(k_1^*, \ldots, k_I^*)}.

Based on the covariate profiles and responses of the first \eqn{n-1} patients, we estimate the target allocation probability \eqn{\widehat{\rho}(\mathbf{X}_n)} for the current patient.

If assigned to treatment 1, we compute imbalance measures between actual and target allocation at three levels:
\itemize{
  \item Overall imbalance: \eqn{D_n^{(1)}(\mathbf{X}_n)},
  \item Marginal imbalance: \eqn{D_n^{(1)}(i; k_i^*; \mathbf{X}_n)},
  \item Within-stratum imbalance: \eqn{D_n^{(1)}(k_1^*, \ldots, k_I^*; \mathbf{X}_n)}.
}

These are combined into a weighted imbalance function:
\deqn{
\operatorname{Imb}_n^{(1)}(\mathbf{X}_n) = w_o [D_n^{(1)}(\mathbf{X}_n)]^2 + \sum_{i=1}^I w_{m,i} [D_n^{(1)}(i; k_i^*; \mathbf{X}_n)]^2 + w_s [D_n^{(1)}(k_1^*, \ldots, k_I^*; \mathbf{X}_n)]^2.
}

A similar imbalance \eqn{\operatorname{Imb}_n^{(2)}(\mathbf{X}_n)} is defined for treatment 2. The patient is then assigned to treatment 1 with probability:
\deqn{
\phi_n = g\left( \operatorname{Imb}_n^{(1)}(\mathbf{X}_n) - \operatorname{Imb}_n^{(2)}(\mathbf{X}_n) \right),
}
where \eqn{g(x)} is a biasing function satisfying \eqn{g(-x) = 1 - g(x)} and \eqn{g(x) < 0.5} for \eqn{x \geq 0}. One common choice is Efron's biased coin function:
\deqn{
g(x) =
\begin{cases}
q, & \text{if } x > 0 \\
0.5, & \text{if } x = 0 \\
p, & \text{if } x < 0
\end{cases}
}
with \eqn{p > 0.5} and \eqn{q = 1 - p}.

This design unifies covariate-adjusted response-adaptive randomization and marginal/stratified balance. It reduces to Hu & Hu's design when \eqn{\mathbf{X}_n} is excluded, and to CARA designs when \eqn{\mathbf{Z}_n} is ignored. More detail can be found in Zhao et al.(2022).
}
\examples{
set.seed(123)
ptsb.X = sample(c(1, -1), 400, replace = TRUE)
ptsb.Z = cbind(
 sample(c(1, -1), 400, replace = TRUE),
 sample(c(1, -1), 400, replace = TRUE)
)
ptsb.Y = sample(c(1, 0), 400, replace = TRUE)
ptsb.t = sample(c(1, 0), 400, replace = TRUE)

## Incoming patient
ptnow.X = 1
ptnow.Z = c(1, -1)

## Run allocation probability calculation
prob = ZhaoNew_Alloc(
 ptsb.X = ptsb.X,
 ptsb.Z = ptsb.Z,
 ptsb.Y = ptsb.Y,
 ptsb.t = ptsb.t,
 ptnow.X = ptnow.X,
 ptnow.Z = ptnow.Z,
 response = "Binary",
 omega = rep(0.25, 4),
 p = 0.8
)

## View allocation probability for treatment A
prob
}
\references{
Zhao, W., Ma, W., Wang, F., & Hu, F. (2022). Incorporating covariates information in adaptive clinical trials for precision medicine.
\emph{Pharmaceutical Statistics}, 21(1), 176–195.
}
\concept{Zhao's New Design}
