% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve_feature_type}
\alias{resolve_feature_type}
\title{Guess the feature type if it was missing}
\usage{
resolve_feature_type(feature_type, feature_names)
}
\arguments{
\item{feature_type}{Type of map feature. See \code{\link[=feature_types]{feature_types()}} for a list of
registered types. If \code{NA}, the type is guessed based on the values in
\code{feature_names}.}

\item{feature_names}{Character vector of feature names in the data. This can
be a subset of the values.}
}
\value{
The resolved feature type as a scalar character.
}
\description{
If \code{feature_type} is provided, this simply checks that the type has been
registered. If it is \code{NA}, however, an attempt it made to guess the
appropriate choice. This is done by comparing the example values provided
as \code{feature_names} with the names of all registered map datasets. If there
is an unambiguous match, that will be filled in.
}
\details{
Cartographer lazy loads map data for registered maps. In order to compare
the example \code{feature_names} with registered maps, it might be necessary
to force some of these datasets to load. To minimise the impact, any maps
that have already been loaded are checked first. Other maps are then
loaded one at a time until any matches are found. Consequently, the result
returned by this function is not deterministic.

In the worst case where none of the registered maps matches, all of them
will be loaded. This might take several seconds and occupy some memory,
depending on which maps are registered. If a match is found, however, it
will be found quickly on subsequent calls since the data will have
already been loaded.

The best way to avoid these issues is to explicitly specify the
\code{feature_type}.
}
\examples{
resolve_feature_type("sf.nc")
resolve_feature_type(NA, feature_names = c("ANSON", "Stanly"))
}
