% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cascadess.R
\name{cascadess_dependencies}
\alias{cascadess_dependencies}
\title{Cascadess' CSS dependencies}
\usage{
cascadess_dependencies()
}
\value{
An \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}.
}
\description{
For CSS styles to be applied, you must include a call to
\code{cascadess_dependencies()} in your UI or use the bslib package.
}
\examples{

\dontrun{
library(shiny)

shinyApp(
  ui = list(
    cascadess_dependencies(),
    div(
      .style \%>\%
        padding_all(3) \%>\%
        background_color(theme_light()),
      "Etiam laoreet quam sed arcu."
    )
  ),
  server = function(input, output) {}
)
}

\dontrun{
library(shiny)
library(bslib)

shinyApp(
  ui = page(
    .style \%>\%
      background_color(theme_primary()),
    card(
      .style \%>\%
        margin_all(3) \%>\%
        background_color(theme_light()),
      "Hello, world!"
    )
  ),
  server = function(input, output) {}
)
}

}
