% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex-wrap.R
\name{flex_wrap}
\alias{flex_wrap}
\title{Flex wrapping}
\usage{
flex_wrap(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A boolean specifying to wrap or not wrap. One of,
\itemize{
\item \code{TRUE}
\item \code{FALSE}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{flex_wrap()} function adjusts how a tag element's child elements wrap,
or don't wrap, onto new lines.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    flex_display() \%>\%
    flex_wrap(FALSE),
  div("Flex item"),
  div("Flex item"),
  div("Flex item"),
  div("Flex item")
)

}
\seealso{
Other flex utilities: 
\code{\link{flex_align}()},
\code{\link{flex_content}()},
\code{\link{flex_direction}()},
\code{\link{flex_display}()},
\code{\link{flex_justify}()},
\code{\link{item_align}()},
\code{\link{item_fill}()},
\code{\link{item_grow}()},
\code{\link{item_order}()}
}
\concept{flex utilities}
