% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focus-color.R
\name{focus_color}
\alias{focus_color}
\title{Focus ring color}
\usage{
focus_color(x, color)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{color}{A character string specifying a color. One of,
\itemize{
\item \code{"primary"}
\item \code{"secondary"}
\item \code{"success"}
\item \code{"danger"}
\item \code{"warning"}
\item \code{"info"}
\item \code{"light"}
\item \code{"dark"}
\item \code{"body"}
\item \code{"black"}
\item \code{"white"}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{focus_color()} function adjusts the focus shadow color of a tag element.
}
\examples{

library(htmltools)

tags$button(
  .style \%>\%
    background_color(theme_primary()) \%>\%
    focus_color(theme_primary()),
  "Primary themed button with primary themed focus ring"
)

}
