% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow.R
\name{shadow}
\alias{shadow}
\title{Visual depth}
\usage{
shadow(x, size)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{size}{A character string specifying the shadow size. One of,
\itemize{
\item \code{"small"}
\item \code{"sm"}
\item \code{"medium"}
\item \code{"md"}
\item \code{"large"}
\item \code{"lg"}
\item \code{"none"}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{shadow()} function adjusts the box shadow of a tag element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    shadow("small")
)

div(
  .style \%>\%
    border_color(theme_warning()) \%>\%
    background_color(theme_warning()) \%>\%
    shadow("medium")
)

}
