% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-color.R
\name{text_color}
\alias{text_color}
\alias{text_emphasis}
\title{Text color}
\usage{
text_color(x, color)

text_emphasis(x, color)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{color}{A character string specifying a color. One of,
\itemize{
\item \code{"primary"}
\item \code{"secondary"}
\item \code{"success"}
\item \code{"danger"}
\item \code{"warning"}
\item \code{"info"}
\item \code{"light"}
\item \code{"dark"}
\item \code{"body"}
\item \code{"black"}
\item \code{"white"}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{text_color()} function adjusts the color of text in a tag element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    text_color(theme_primary())
)

div(
  .style \%>\%
    text_color(theme_dark()) \%>\%
    border_color(theme_dark())
)

}
\seealso{
Other text utilities: 
\code{\link{text_alignment}()},
\code{\link{text_break}()},
\code{\link{text_decoration}()},
\code{\link{text_height}()},
\code{\link{text_selection}()},
\code{\link{text_style}()},
\code{\link{text_transform}()},
\code{\link{text_weight}()},
\code{\link{text_wrap}()}
}
\concept{text utilities}
