% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/width-relative.R
\name{width_relative}
\alias{width_relative}
\title{Relative width}
\usage{
width_relative(x, percent)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{percent}{A number specifying a percent. One of,
\itemize{
\item \code{25}
\item \code{50}
\item \code{75}
\item \code{100}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{width_relative()} function adjusts a tag element's width relative to its
parent element's width.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    width_relative(25)
)

div(
  .style \%>\%
    width_relative(100)
)

}
