% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/height-relative.R
\name{height_relative}
\alias{height_relative}
\title{Relative height}
\usage{
height_relative(x, percent)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{percent}{A number specifying a percent. One of,
\itemize{
\item \code{25}
\item \code{50}
\item \code{75}
\item \code{100}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{height_relative()} function adjusts a tag element's height relative to
the height of its parent element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    height_relative(50)
)

div(
  .style \%>\%
    height_relative(75)
)

}
