% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item-grow.R
\name{item_grow}
\alias{item_grow}
\alias{item_shrink}
\title{Flex grow and shrink}
\usage{
item_grow(x, ...)

item_shrink(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A boolean specifying to grow or shrink. One of,
\itemize{
\item \code{TRUE}
\item \code{FALSE}

Use name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{item_grow()} and \code{item_shrink()} adjust a tag element's ability to grow
or shrink inside a flex element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    flex_display(),
  div(
    .style \%>\%
      padding_all(2) \%>\%
      item_grow(TRUE),
    "Flex item"
  ),
  div(
    .style \%>\%
      padding_all(2),
    "Flex item"
  ),
  div(
    .style \%>\%
      padding_all(2),
    "Flex item"
  )
)

}
\seealso{
Other flex utilities: 
\code{\link{flex_align}()},
\code{\link{flex_content}()},
\code{\link{flex_direction}()},
\code{\link{flex_display}()},
\code{\link{flex_justify}()},
\code{\link{flex_wrap}()},
\code{\link{item_align}()},
\code{\link{item_fill}()},
\code{\link{item_order}()}
}
\concept{flex utilities}
