% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack-vertical.R
\name{stack_vertical}
\alias{stack_vertical}
\alias{stack_horizontal}
\title{Quick flex layouts}
\usage{
stack_vertical(x)

stack_horizontal(x)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{stack_vertical()} and \code{stack_horizontal()} functions are shortcuts
for creating vertical and horizontal flex layouts.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    stack_vertical() \%>\%
    gap_all(3),
  p(
    .style \%>\%
      border_all() \%>\%
      padding_all(2),
    "First item"
  ),
  p(
    .style \%>\%
      border_all() \%>\%
      padding_all(2),
    "Second item"
  ),
  p(
    .style \%>\%
      border_all() \%>\%
      padding_all(2),
    "Third item"
  )
)
}
