% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-height.R
\name{text_height}
\alias{text_height}
\title{Text height}
\usage{
text_height(x, height)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{height}{A character string specifying a line height. One of,
\itemize{
\item \code{"sm"}
\item \code{"small"}
\item \code{"base"}
\item \code{"lg"}
\item \code{"large"}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{text_height()} function adjusts the line height of text within a tag
element.
}
\examples{

library(htmltools)

p(
  .style \%>\%
    text_height("base"),
  "This is the browser's default line height spacing.",
  "Make sure there are multiple lines of text in a paragraph.",
  "Otherwise, the changes applied by these utilities are not visible."
)

}
\seealso{
Other text utilities: 
\code{\link{text_alignment}()},
\code{\link{text_break}()},
\code{\link{text_color}()},
\code{\link{text_decoration}()},
\code{\link{text_selection}()},
\code{\link{text_style}()},
\code{\link{text_transform}()},
\code{\link{text_weight}()},
\code{\link{text_wrap}()}
}
\concept{text utilities}
