% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Copula.R
\docType{methods}
\name{setDispstr<-}
\alias{setDispstr<-}
\alias{setDispstr<-,CopulaObj,character-method}
\alias{setDispstr,ANY-method}
\title{Set parameter matrix format of Elliptical copula.}
\usage{
setDispstr(this, ...) <- value

\S4method{setDispstr}{CopulaObj,character}(this) <- value
}
\arguments{
\item{this}{Copula Object}

\item{...}{Additional function arguments}

\item{value}{The matrix format. The default is "un" for unstructured. Other choices include "ex" for exchangeable, "ar1" for AR(1), and "toep" for Toeplitz (toeplitz).}
}
\description{
Set parameter matrix format of Elliptical copula.
}
\examples{
library(cascsim)
dist1<-new("Pareto",p1=20,p2=3)
dist2<-new("Normal",p1=5,p2=3,min=0,max=20,truncated=TRUE)
cop <- new("CopulaObj", param=c(0.5),marginal=list(dist1=dist1,dist2=dist2),dimension=2)
setDispstr(cop) <- "ex"
}
