% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat2cat_ml.R
\name{cat2cat_ml_run}
\alias{cat2cat_ml_run}
\alias{print.cat2cat_ml_run}
\title{Function to check cat2cat ml models performance}
\usage{
cat2cat_ml_run(mappings, ml, ...)

\method{print}{cat2cat_ml_run}(x, ...)
}
\arguments{
\item{mappings}{`named list` with 3 fields `trans`, `direction` and
optional `freqs_df`.}

\item{ml}{`named list` (optional) with up to 5 fields
`data`, `cat_var`, `method`, `features` and optional `args`.}

\item{...}{other arguments}

\item{x}{cat2cat_ml_run instance created with \code{\link{cat2cat_ml_run}} function.}
}
\value{
argument x invisibly
}
\description{
ml and mappings arguments in \code{\link{cat2cat}} function can be used to run cross validation across all groups in ml data.
}
\examples{
\dontrun{
library("cat2cat")
data("occup", package = "cat2cat")
data("trans", package = "cat2cat")

occup_2006 <- occup[occup$year == 2006, ]
occup_2008 <- occup[occup$year == 2008, ]
occup_2010 <- occup[occup$year == 2010, ]
occup_2012 <- occup[occup$year == 2012, ]

library("caret")
ml_setup <- list(
  data = rbind(occup_2010, occup_2012),
  cat_var = "code",
  method = c("knn", "rf", "lda"),
  features = c("age", "sex", "edu", "exp", "parttime", "salary"),
  args = list(k = 10, ntree = 50)
)
data <- list(
  old = occup_2008, new = occup_2010,
  cat_var_old = "code", cat_var_new = "code", time_var = "year"
)
mappings <- list(trans = trans, direction = "backward")
res <- cat2cat_ml_run(mappings, ml_setup, test_prop = 0.2)
res
}

}
\seealso{
\code{\link{cat2cat}}
}
