% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registry.R
\name{register_caugi_edge}
\alias{register_caugi_edge}
\title{Register a new edge type in the global registry.}
\usage{
register_caugi_edge(glyph, tail_mark, head_mark, class, symmetric = FALSE)
}
\arguments{
\item{glyph}{A string representing the edge glyph (e.g., \code{"-->"}, \code{"<->"}).}

\item{tail_mark}{One of "arrow", "tail", "circle", "other".}

\item{head_mark}{One of "arrow", "tail", "circle", "other".}

\item{class}{One of "directed","undirected","bidirected","partial".}

\item{symmetric}{Logical.}
}
\value{
TRUE, invisibly.
}
\description{
Register a new edge type in the global registry.
}
\examples{
# first, for reproducability, we reset the registry to default
reset_caugi_registry()

# create a new registry
reg <- caugi_registry()

# register an edge
register_caugi_edge(
  glyph = "<--",
  tail_mark = "arrow",
  head_mark = "tail",
  class = "directed",
  symmetric = FALSE
)

# now, this edge is available for caugi graphs:
cg <- caugi(A \%-->\% B, B \%<--\% C, class = "DAG")

# reset the registry to default
reset_caugi_registry()

}
\seealso{
Other registry: 
\code{\link{registry}}
}
\concept{registry}
